/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.derby.test;

import java.io.PrintWriter;
import java.io.Writer;
import javax.sql.DataSource;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.codefilarete.stalactite.sql.UrlAwareDataSource;
import org.codefilarete.tool.bean.Randomizer;

public class DerbyInMemoryDataSource
extends UrlAwareDataSource {
    public static final PrintWriter NOOP_LOGGER = new PrintWriter(new NoopWriter());

    public DerbyInMemoryDataSource() {
        this(Randomizer.INSTANCE.randomHexString(8));
    }

    private DerbyInMemoryDataSource(String databaseName) {
        super("jdbc:derby:memory:" + databaseName);
        EmbeddedDataSource delegate = new EmbeddedDataSource();
        delegate.setDatabaseName("memory:" + databaseName);
        delegate.setCreateDatabase("create");
        this.fixDerbyLogger();
        this.setDelegate((DataSource)delegate);
    }

    protected void fixDerbyLogger() {
        System.setProperty("derby.stream.error.field", DerbyInMemoryDataSource.class.getName() + ".NOOP_LOGGER");
    }

    private static class NoopWriter
    extends Writer {
        private NoopWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

